import pool from '../../lib/db';

export default async function handler(req, res) {
  if (req.method === 'GET') {
    try {
      const [rows] = await pool.query('SELECT * FROM users ORDER BY id DESC');
      res.status(200).json({ success: true, data: rows });
    } catch (err) {
      console.error(err);
      res.status(500).json({ success: false, message: 'Database error' });
    }
  } else if (req.method === 'POST') {
    try {
      const { name, email } = req.body;
      if (!name || !email) return res.status(400).json({ success: false, message: 'Name and email required' });
      const [result] = await pool.query('INSERT INTO users (name, email) VALUES (?, ?)', [name, email]);
      res.status(201).json({ success: true, insertId: result.insertId });
    } catch (err) {
      console.error(err);
      res.status(500).json({ success: false, message: 'Insert error' });
    }
  } else {
    res.setHeader('Allow', ['GET', 'POST']);
    res.status(405).json({ success: false, message: 'Method not allowed' });
  }
}
